﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Tasks;

namespace FlickrNetPhone7App
{
    public partial class AuthenticatePage : PhoneApplicationPage
    {
        string frob;
        bool checking = false;

        public AuthenticatePage()
        {
            InitializeComponent();
        }

        private void PhoneApplicationPage_Loaded(object sender, RoutedEventArgs e)
        {
            if (!String.IsNullOrEmpty(SettingsHelper.AuthenticationToken) && NavigationContext.QueryString.Count == 0)
            {
                // Going to skip this page, so don't load the web browser.
                return;
            }

            App app = Application.Current as App;
            app.Flickr.AuthGetFrobAsync(r =>
                {
                    Dispatcher.BeginInvoke(() =>
                        {
                            if (r.HasError)
                                StatusTextBox.Text = r.Error.Message;
                            else
                            {
                                frob = r.Result;
                                WebBrowser1.Navigate(new Uri(app.Flickr.AuthCalcUrlAsync(frob, FlickrNet.AuthLevel.Write)));
                            }
                        });
                });

        }

        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            if (!String.IsNullOrEmpty(SettingsHelper.AuthenticationToken) && NavigationContext.QueryString.Count == 0)
            {
                if (NavigationService.CanGoBack)
                    NavigationService.GoBack();
            }

            base.OnNavigatedTo(e);
        }

        public void ApplicationBarAuthenticateIconButton_Click(object sender, EventArgs e)
        {
            if (checking) return;

        }

        public void ApplicationBarContinueIconButton_Click(object sender, EventArgs e)
        {
            // If already checking the return
            if (checking) return;

            // If not authenticate then check to see if frob has been approved.
            if (String.IsNullOrEmpty(SettingsHelper.AuthenticationToken))
            {
                checking = true;
                App app = Application.Current as App;

                app.Flickr.AuthGetTokenAsync(frob, r =>
                {
                    Dispatcher.BeginInvoke(() =>
                    {
                        if (r.HasError)
                        {
                            if (r.ErrorCode == 1)
                            {
                                MessageBox.Show("You must authenticate before you can upload. Please completed the web page authentication above.");
                            }
                            else
                            {
                                MessageBox.Show(r.Error.Message);
                            }
                        }
                        else
                        {
                            SettingsHelper.AuthenticationToken = r.Result.Token;

                            NavigationService.Navigate(new Uri("/UploadPage.xaml", UriKind.Relative));
                        }

                        checking = false;

                    });
                });

                return;
            }

            NavigationService.Navigate(new Uri("/UploadPage.xaml", UriKind.Relative));
        }
    }
}