﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Tasks;
using FlickrNet;
using System.Windows.Media.Imaging;
using System.IO.IsolatedStorage;
using Microsoft.Phone;
using System.IO;

namespace FlickrNetPhone7App
{
    public partial class MainPage : PhoneApplicationPage
    {
        CameraCaptureTask cameraChooser;
        PhotoChooserTask photoChooser;

        public MainPage()
        {
            InitializeComponent();

            SupportedOrientations = SupportedPageOrientation.Portrait | SupportedPageOrientation.Landscape;
        }

        private void PhoneApplicationPage_Loaded(object sender, RoutedEventArgs e)
        {
            cameraChooser = new CameraCaptureTask();
            cameraChooser.Completed += new EventHandler<PhotoResult>(Chooser_Completed);

            photoChooser = new PhotoChooserTask();
            photoChooser.Completed += new EventHandler<PhotoResult>(Chooser_Completed);
        }

        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedTo(e);

            var queryStrings = this.NavigationContext.QueryString;

            //This code ensures that there is at least one key in the query string, and check if the "file" key is present.
            if (queryStrings.Count > 0 && queryStrings.ContainsKey("file"))
            {
                //The value for the key "file" is filename.
                string filename = queryStrings["file"];

                //This code appends the folder name (Incoming) to the file path. The isolated storage folder "Incoming"
                // was specified in the Extras.xml file.     
                SetImage(ImageHelper.LoadImage(ImageHelper.IncomingDirectory, filename));

                // Clean up incoming directory
                ImageHelper.DeleteImage(ImageHelper.IncomingDirectory, filename);
            }
        }

        void Chooser_Completed(object sender, PhotoResult e)
        {
            if (e == null || e.TaskResult != TaskResult.OK) return;

            SetImage(e.ChosenPhoto);
        }

        private void SetImage(Stream imageStream)
        {
            ImageHelper.SaveImage(imageStream, ImageHelper.ImageDirectory, SettingsHelper.ImageFilename);

            BitmapImage bmp = new BitmapImage();
            bmp.SetSource(imageStream);
            PlaceHolderImage.Source = bmp;

            if (ApplicationBarUploadIconButton != null)
                ApplicationBarUploadIconButton.IsEnabled = true;
        }

        private void ApplicationBarCameraIconButton_Click(object sender, EventArgs e)
        {
            cameraChooser.Show();
        }

        private void ApplicationBarSearchIconButton_Click(object sender, EventArgs e)
        {
            photoChooser.Show();
        }

        private void ApplicationBarUploadIconButton_Click(object sender, EventArgs e)
        {
            if (!ImageHelper.ImageExists(ImageHelper.ImageDirectory, SettingsHelper.ImageFilename))
            {
                MessageBox.Show("You must take a photo or choose a photo to continue.");
            }

            if (String.IsNullOrEmpty(SettingsHelper.AuthenticationToken))
                NavigationService.Navigate(new Uri("/AuthenticatePage.xaml", UriKind.Relative));
            else
                NavigationService.Navigate(new Uri("/UploadPage.xaml", UriKind.Relative));
        }
    }
}