﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using FlickrNet;
using System.IO;

namespace FlickrNetPhone7App
{
    public partial class UploadPage : PhoneApplicationPage
    {
        public UploadPage()
        {
            InitializeComponent();
        }

        private void TextBox_GotFocus(object sender, RoutedEventArgs e)
        {

        }

        private void PhoneApplicationPage_Loaded(object sender, RoutedEventArgs e)
        {
            if (DataContext == null)
                DataContext = (Application.Current as App).UploadViewModel;
        }

        private void ApplicationBarUploadIconButton_Click(object sender, EventArgs e)
        {
            ApplicationBarUploadIconButton.IsEnabled = false;

            App app = Application.Current as App;

            Flickr f = app.Flickr;
            UploadDataViewModel data = app.UploadViewModel;

            Stream stream = ImageHelper.LoadImage(ImageHelper.ImageDirectory, SettingsHelper.ImageFilename);

            if (stream == null)
            {
                MessageBox.Show("No image found. Please go back and choose an image to upload.");
                return;
            }

            ContentGrid.Visibility = System.Windows.Visibility.Collapsed;
            UploadProgressBar.Visibility = System.Windows.Visibility.Visible;

            f.UploadPictureAsync(stream, "image.jpg", data.Title, data.Description, data.Tags, true, true, true, ContentType.Photo, SafetyLevel.None, HiddenFromSearch.None, r =>
                {
                    Dispatcher.BeginInvoke(() =>
                    {
                        UploadProgressBar.Visibility = System.Windows.Visibility.Collapsed;
                        MessageBox.Show("Upload complete!");

                        if (NavigationService.CanGoBack) NavigationService.GoBack();
                    });
                });

        }
    }
}